/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends amr<uy>
implements anp,
cy,
AutoCloseable {
    private static final Logger j = LogManager.getLogger();
    public static final File b = new File("usercache.json");
    public static final bqe c = new bqe("Demo World", bpy.b, false, and.c, false, new bpx(), bpn.a);
    protected final dae.a d;
    protected final dai e;
    private final ano k = new ano("server", this, v.b());
    private final List<Runnable> l = Lists.newArrayList();
    private amc m = new amc(v.a, this::ag);
    private ami n = amf.a;
    private final zu o;
    private final zn p;
    private final tl q = new tl();
    private final Random r = new Random();
    private final DataFixer s;
    private String t;
    private int u = -1;
    protected final gm.a f;
    private final Map<ug<bqb>, zd> v = Maps.newLinkedHashMap();
    private abp w;
    private volatile boolean x = true;
    private boolean y;
    private int z;
    protected final Proxy g;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    @Nullable
    private String E;
    private int F;
    private int G;
    public final long[] h = new long[100];
    @Nullable
    private KeyPair H;
    @Nullable
    private String I;
    private boolean J;
    private String K = "";
    private String L = "";
    private volatile boolean M;
    private long N;
    private boolean O;
    private boolean P;
    private final MinecraftSessionService Q;
    private final GameProfileRepository R;
    private final abl S;
    private long T;
    private final Thread U;
    private long V = v.b();
    private long W;
    private boolean X;
    private boolean Y;
    private final aar<aap> Z;
    private final ux aa = new ux(this);
    @Nullable
    private czy ab;
    private final va ac = new va();
    private final uu ad;
    private final ads ae = new ads();
    private boolean af;
    private float ag;
    private final Executor ah;
    @Nullable
    private String ai;
    private uw aj;
    private final cva ak;
    protected final dal i;

    public static <S extends MinecraftServer> S a(Function<Thread, S> function) {
        AtomicReference<MinecraftServer> atomicReference = new AtomicReference<MinecraftServer>();
        Thread \u26032 = new Thread(() -> ((MinecraftServer)atomicReference.get()).v(), "Server thread");
        \u26032.setUncaughtExceptionHandler((thread, throwable) -> j.error((Object)throwable));
        MinecraftServer \u26033 = (MinecraftServer)function.apply(\u26032);
        atomicReference.set(\u26033);
        \u26032.start();
        return (S)\u26033;
    }

    public MinecraftServer(Thread thread, gm.a a2, dae.a a3, dal dal2, aar<aap> aar2, Proxy proxy, DataFixer dataFixer, uw uw2, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, abl abl2, zn zn2) {
        super("Server");
        this.f = a2;
        this.i = dal2;
        this.g = proxy;
        this.Z = aar2;
        this.aj = uw2;
        this.Q = minecraftSessionService;
        this.R = gameProfileRepository;
        this.S = abl2;
        this.o = new zu(this);
        this.p = zn2;
        this.d = a3;
        this.e = a3.b();
        this.s = dataFixer;
        this.ad = new uu(this, uw2.a());
        this.ak = new cva(uw2.h(), a3, dataFixer);
        this.U = thread;
        this.ah = v.f();
    }

    @Override
    private void a(daa daa2) {
        dfn dfn2 = daa2.a(dfn::new, "scoreboard");
        dfn2.a(this.aF());
        this.aF().a(new czp(dfn2));
    }

    protected abstract boolean d() throws IOException;

    public static void a(dae.a a2) {
        if (a2.c()) {
            j.info("Converting map!");
            a2.a(new aed(){
                private long a = v.b();

                @Override
                public void a(mr mr2) {
                }

                @Override
                public void b(mr mr2) {
                }

                @Override
                public void a(int n2) {
                    if (v.b() - this.a >= 1000L) {
                        this.a = v.b();
                        j.info("Converting... {}%", (Object)n2);
                    }
                }

                @Override
                public void a() {
                }

                @Override
                public void c(mr mr2) {
                }
            });
        }
    }

    protected void l_() {
        this.q();
        this.i.a(this.getServerModName(), this.n().isPresent());
        zm zm2 = this.p.create(11);
        this.a(zm2);
        this.p();
        this.b(zm2);
    }

    protected void p() {
    }

    @Override
    protected void a(zm zm2) {
        cha \u26039;
        dak dak2 = this.i.G();
        cix \u26032 = this.i.z();
        boolean \u26033 = \u26032.h();
        long \u26034 = \u26032.b();
        long \u26035 = brg.a(\u26034);
        ImmutableList \u26036 = ImmutableList.of((Object)new civ(), (Object)new ciu(), (Object)new bdl(), (Object)new axx(), (Object)new bdw(dak2));
        gh<cig> \u26037 = \u26032.e();
        cig \u26038 = \u26037.a(cig.b);
        if (\u26038 == null) {
            cif cif2 = cif.a();
            \u26039 = cix.a(new Random().nextLong());
        } else {
            cif2 = \u26038.b();
            \u26039 = \u26038.c();
        }
        ug<cif> ug2 = this.f.a().c(cif2).orElseThrow(() -> new IllegalStateException("Unregistered dimension type: " + cif2));
        zd \u260310 = new zd(this, this.ah, this.d, dak2, bqb.g, ug2, cif2, zm2, \u26039, \u26033, \u26035, (List<bpm>)\u26036, true);
        this.v.put(bqb.g, \u260310);
        daa \u260311 = \u260310.s();
        this.a(\u260311);
        this.ab = new czy(\u260311);
        cgw \u260312 = \u260310.f();
        \u260312.a(dak2.q());
        if (!dak2.o()) {
            try {
                MinecraftServer.a(\u260310, dak2, \u26032.d(), \u26033, true);
                dak2.c(true);
                if (\u26033) {
                    this.a(this.i);
                }
            }
            catch (Throwable throwable) {
                j j2 = j.a(throwable, "Exception initializing level");
                try {
                    \u260310.a(j2);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new s(j2);
            }
            dak2.c(true);
        }
        this.ac().a(\u260310);
        if (this.i.D() != null) {
            this.aK().a(this.i.D());
        }
        for (Map.Entry<ug<cig>, cig> entry : \u26037.c()) {
            ug<cig> ug3 = entry.getKey();
            if (ug3 == cig.b) continue;
            ug<bqb> \u260313 = ug.a(gl.ae, ug3.a());
            cif \u260314 = entry.getValue().b();
            ug<cif> \u260315 = this.f.a().c(\u260314).orElseThrow(() -> new IllegalStateException("Unregistered dimension type: " + \u260314));
            cha \u260316 = entry.getValue().c();
            czz \u260317 = new czz(this.i, dak2);
            zd \u260318 = new zd(this, this.ah, this.d, \u260317, \u260313, \u260315, \u260314, zm2, \u260316, \u26033, \u26035, (List<bpm>)ImmutableList.of(), false);
            \u260312.a(new cgu.a(\u260318.f()));
            this.v.put(\u260313, \u260318);
        }
    }

    private static void a(zd zd2, dak dak22, boolean bl22, boolean bl3, boolean bl4) {
        boolean bl22;
        dak dak22;
        cha cha2 = zd2.i().g();
        if (!bl4) {
            dak22.a(fu.b.b(cha2.c()));
            return;
        }
        if (bl3) {
            dak22.a(fu.b.b());
            return;
        }
        brh \u26032 = cha2.d();
        List<bre> \u26033 = \u26032.b();
        Random \u26034 = new Random(zd2.B());
        fu \u26035 = \u26032.a(0, zd2.t_(), 0, 256, \u26033, \u26034);
        bph bph2 = \u2603 = \u26035 == null ? new bph(0, 0) : new bph(\u26035);
        if (\u26035 == null) {
            j.warn("Unable to find spawn biome");
        }
        boolean \u26036 = false;
        for (bvr bvr2 : acx.U.b()) {
            if (!\u26032.d().contains(bvr2.n())) continue;
            \u26036 = true;
            break;
        }
        dak22.a(\u2603.l().b(8, cha2.c(), 8));
        int \u26037 = 0;
        int \u26038 = 0;
        int \u26039 = 0;
        int \u260310 = -1;
        int \u260311 = 32;
        for (int i2 = 0; i2 < 1024; ++i2) {
            if (\u26037 > -16 && \u26037 <= 16 && \u26038 > -16 && \u26038 <= 16 && (\u2603 = yy.a(zd2, new bph(\u2603.b + \u26037, \u2603.c + \u26038), \u26036)) != null) {
                dak22.a(\u2603);
                break;
            }
            if (\u26037 == \u26038 || \u26037 < 0 && \u26037 == -\u26038 || \u26037 > 0 && \u26037 == 1 - \u26038) {
                \u2603 = \u26039;
                \u26039 = -\u260310;
                \u260310 = \u2603;
            }
            \u26037 += \u26039;
            \u26038 += \u260310;
        }
        if (bl22) {
            ckb<coa, ?> ckb2 = ckt.T.b(cnr.k);
            ckb2.a(zd2, zd2.a(), cha2, zd2.t, new fu(dak22.a(), dak22.b(), dak22.c()));
        }
    }

    @Override
    private void a(dal dal2) {
        dal2.a(and.a);
        dal2.d(true);
        dak dak2 = dal2.G();
        dak2.b(false);
        dak2.a(false);
        dak2.a(1000000000);
        dak2.b(6000L);
        dak2.a(bpy.e);
    }

    private void b(zm zm2) {
        zd zd2 = this.D();
        j.info("Preparing start region for dimension {}", (Object)zd2.W().a());
        fu \u26032 = zd2.u();
        zm2.a(new bph(\u26032));
        zb \u26033 = zd2.i();
        \u26033.a().a(500);
        this.V = v.b();
        \u26033.a(zi.a, new bph(\u26032), 11, ael.a);
        while (\u26033.b() != 441) {
            this.V = v.b() + 10L;
            this.w();
        }
        this.V = v.b() + 10L;
        this.w();
        for (zd zd3 : this.v.values()) {
            bpw bpw2 = zd3.s().b(bpw::new, "chunks");
            if (bpw2 == null) continue;
            LongIterator \u26034 = bpw2.a().iterator();
            while (\u26034.hasNext()) {
                long l2 = \u26034.nextLong();
                bph \u26035 = new bph(l2);
                zd3.i().a(\u26035, true);
            }
        }
        this.V = v.b() + 10L;
        this.w();
        zm2.b();
        \u26033.a().a(5);
        this.ba();
    }

    protected void q() {
        File file = this.d.a(dac.h).toFile();
        if (file.isFile()) {
            String string = this.d.a();
            try {
                this.a("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException \u26032) {
                j.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public bpy r() {
        return this.i.l();
    }

    public boolean f() {
        return this.i.m();
    }

    public abstract int g();

    public abstract int h();

    public abstract boolean i();

    public boolean a(boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        for (zd zd2 : this.F()) {
            if (!bl2) {
                j.info("Saving chunks for level '{}'/{}", (Object)zd2, (Object)zd2.W().a());
            }
            zd2.a(null, bl3, zd2.c && !bl4);
            bl5 = true;
        }
        zd zd2 = this.D();
        dak dak2 = this.i.G();
        dak2.a(zd2.f().t());
        this.i.b(this.aK().c());
        this.d.a(this.f, this.i, this.ac().q());
        return bl5;
    }

    @Override
    public void close() {
        this.s();
    }

    protected void s() {
        j.info("Stopping server");
        if (this.ad() != null) {
            this.ad().b();
        }
        if (this.w != null) {
            j.info("Saving players");
            this.w.h();
            this.w.r();
        }
        j.info("Saving worlds");
        for (zd zd2 : this.F()) {
            if (zd2 == null) continue;
            zd2.c = false;
        }
        this.a(false, true, false);
        for (zd zd2 : this.F()) {
            if (zd2 == null) continue;
            try {
                zd2.close();
            }
            catch (IOException iOException) {
                j.error("Exception closing the level", (Throwable)iOException);
            }
        }
        if (this.k.d()) {
            this.k.e();
        }
        this.aj.close();
        try {
            this.d.close();
        }
        catch (IOException iOException) {
            j.error("Failed to unlock level {}", (Object)this.d.a(), (Object)iOException);
        }
    }

    public String t() {
        return this.t;
    }

    public void a_(String string) {
        this.t = string;
    }

    public boolean u() {
        return this.x;
    }

    @Override
    public void a(boolean bl2) {
        this.x = false;
        if (bl2) {
            try {
                this.U.join();
            }
            catch (InterruptedException interruptedException) {
                j.error("Error while shutting down", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void v() {
        try {
            if (this.d()) {
                this.V = v.b();
                this.q.a(new nd(this.E));
                this.q.a(new tl.c(u.a().getName(), u.a().getProtocolVersion()));
                this.a(this.q);
                while (this.x) {
                    long l2 = v.b() - this.V;
                    if (l2 > 2000L && this.V - this.N >= 15000L) {
                        \u2603 = l2 / 50L;
                        j.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l2, (Object)\u2603);
                        this.V += \u2603 * 50L;
                        this.N = this.V;
                    }
                    this.V += 50L;
                    aml \u26032 = aml.a("Server");
                    this.a(\u26032);
                    this.n.a();
                    this.n.a("tick");
                    this.a(this::aY);
                    this.n.b("nextTickWait");
                    this.X = true;
                    this.W = Math.max(v.b() + 50L, this.V);
                    this.w();
                    this.n.c();
                    this.n.b();
                    this.b(\u26032);
                    this.M = true;
                }
            } else {
                this.a((j)null);
            }
        }
        catch (Throwable throwable) {
            j.error("Encountered an unexpected exception", throwable);
            j j2 = throwable instanceof s ? this.b(((s)throwable).a()) : this.b(new j("Exception in server tick loop", throwable));
            File \u26033 = new File(new File(this.A(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (j2.a(\u26033)) {
                j.error("This crash report has been saved to: {}", (Object)\u26033.getAbsolutePath());
            } else {
                j.error("We were unable to save this crash report to disk.");
            }
            this.a(j2);
        }
        finally {
            try {
                this.y = true;
                this.s();
            }
            catch (Throwable \u26034) {
                j.error("Exception stopping the server", \u26034);
            }
            finally {
                this.e();
            }
        }
    }

    private boolean aY() {
        return this.bl() || v.b() < (this.X ? this.W : this.V);
    }

    protected void w() {
        this.bj();
        this.c(() -> !this.aY());
    }

    protected uy a(Runnable runnable) {
        return new uy(this.z, runnable);
    }

    protected boolean a(uy uy2) {
        return uy2.a() + 3 < this.z || this.aY();
    }

    @Override
    public boolean x() {
        boolean bl2;
        this.X = bl2 = this.aZ();
        return bl2;
    }

    private boolean aZ() {
        if (super.x()) {
            return true;
        }
        if (this.aY()) {
            for (zd zd2 : this.F()) {
                if (!zd2.i().d()) continue;
                return true;
            }
        }
        return false;
    }

    protected void b(uy uy2) {
        this.aO().c("runTask");
        super.c(uy2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private void a(tl tl2) {
        File file = this.c("server-icon.png");
        if (!file.exists()) {
            file = this.d.f();
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuffer \u26032 = Base64.getEncoder().encode(byteBuf.nioBuffer());
                tl2.a("data:image/png;base64," + StandardCharsets.UTF_8.decode(\u26032));
            }
            catch (Exception exception) {
                j.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public boolean y() {
        this.Y = this.Y || this.z().isFile();
        return this.Y;
    }

    public File z() {
        return this.d.f();
    }

    public File A() {
        return new File(".");
    }

    @Override
    protected void a(j j2) {
    }

    protected void e() {
    }

    @Override
    protected void a(BooleanSupplier booleanSupplier) {
        long l2 = v.c();
        ++this.z;
        this.b(booleanSupplier);
        if (l2 - this.T >= 5000000000L) {
            this.T = l2;
            this.q.a(new tl.a(this.I(), this.H()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.H(), 12)];
            int \u26032 = aec.a(this.r, 0, this.H() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.w.s().get(\u26032 + i2).ez();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.q.b().a(gameProfileArray);
        }
        if (this.z % 6000 == 0) {
            j.debug("Autosave started");
            this.n.a("save");
            this.w.h();
            this.a(true, false, false);
            this.n.c();
            j.debug("Autosave finished");
        }
        this.n.a("snooper");
        if (!this.k.d() && this.z > 100) {
            this.k.a();
        }
        if (this.z % 6000 == 0) {
            this.k.b();
        }
        this.n.c();
        this.n.a("tallying");
        long l3 = v.c() - l2;
        this.h[this.z % 100] = l3;
        \u2603 = l3;
        this.ag = this.ag * 0.8f + (float)\u2603 / 1000000.0f * 0.19999999f;
        \u2603 = v.c();
        this.ae.a(\u2603 - l2);
        this.n.c();
    }

    protected void b(BooleanSupplier booleanSupplier) {
        this.n.a("commandFunctions");
        this.az().d();
        this.n.b("levels");
        for (zd zd2 : this.F()) {
            this.n.a(() -> zd2 + " " + zd2.W().a());
            if (this.z % 20 == 0) {
                this.n.a("timeSync");
                this.w.a(new qj(zd2.Q(), zd2.R(), zd2.S().b(bpx.j)), zd2.W());
                this.n.c();
            }
            this.n.a("tick");
            try {
                zd2.a(booleanSupplier);
            }
            catch (Throwable throwable) {
                j j2 = j.a(throwable, "Exception ticking world");
                zd2.a(j2);
                throw new s(j2);
            }
            this.n.c();
            this.n.c();
        }
        this.n.b("connection");
        this.ad().c();
        this.n.b("players");
        this.w.d();
        if (u.d) {
            km.a.b();
        }
        this.n.b("server gui refresh");
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            this.l.get(i2).run();
        }
        this.n.c();
    }

    public boolean B() {
        return true;
    }

    public void b(Runnable runnable) {
        this.l.add(runnable);
    }

    protected void b(String string) {
        this.ai = string;
    }

    public boolean C() {
        return !this.U.isAlive();
    }

    public File c(String string) {
        return new File(this.A(), string);
    }

    public final zd D() {
        return this.v.get(bqb.g);
    }

    @Nullable
    public zd a(ug<bqb> ug2) {
        return this.v.get(ug2);
    }

    public Set<ug<bqb>> E() {
        return this.v.keySet();
    }

    public Iterable<zd> F() {
        return this.v.values();
    }

    public String G() {
        return u.a().getName();
    }

    public int H() {
        return this.w.m();
    }

    public int I() {
        return this.w.n();
    }

    public String[] J() {
        return this.w.e();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public j b(j j2) {
        if (this.w != null) {
            j2.g().a("Player Count", () -> this.w.m() + " / " + this.w.n() + "; " + this.w.s());
        }
        j2.g().a("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (aap aap2 : this.Z.e()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(aap2.e());
                if (aap2.c().a()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        if (this.ai != null) {
            j2.g().a("Server Id", () -> this.ai);
        }
        return j2;
    }

    public abstract Optional<String> n();

    @Override
    public void a(mr mr2, UUID uUID) {
        j.info(mr2.getString());
    }

    public KeyPair K() {
        return this.H;
    }

    public int L() {
        return this.u;
    }

    @Override
    public void a(int n2) {
        this.u = n2;
    }

    public String M() {
        return this.I;
    }

    public void d(String string) {
        this.I = string;
    }

    public boolean N() {
        return this.I != null;
    }

    @Override
    public void a(KeyPair keyPair) {
        this.H = keyPair;
    }

    public void a(and and2, boolean bl2) {
        if (!bl2 && this.i.s()) {
            return;
        }
        this.i.a(this.i.m() ? and.d : and2);
        this.ba();
        this.ac().s().forEach(this::a);
    }

    public int b(int n2) {
        return n2;
    }

    private void ba() {
        for (zd zd2 : this.F()) {
            zd2.b(this.O(), this.V());
        }
    }

    public void b(boolean bl2) {
        this.i.d(bl2);
        this.ac().s().forEach(this::a);
    }

    @Override
    private void a(ze ze2) {
        dab dab2 = ze2.u().u_();
        ze2.b.a(new nz(dab2.r(), dab2.s()));
    }

    protected boolean O() {
        return this.i.r() != and.a;
    }

    public boolean P() {
        return this.J;
    }

    @Override
    public void c(boolean bl2) {
        this.J = bl2;
    }

    public String Q() {
        return this.K;
    }

    public String R() {
        return this.L;
    }

    public void a(String string, String string2) {
        this.K = string;
        this.L = string2;
    }

    @Override
    public void a(ano ano22) {
        ano ano22;
        ano22.a("whitelist_enabled", false);
        ano22.a("whitelist_count", 0);
        if (this.w != null) {
            ano22.a("players_current", this.H());
            ano22.a("players_max", this.I());
            ano22.a("players_seen", this.e.a().length);
        }
        ano22.a("uses_auth", this.A);
        ano22.a("gui_state", this.af() ? "enabled" : "disabled");
        ano22.a("run_time", (v.b() - ano22.g()) / 60L * 1000L);
        ano22.a("avg_tick_ms", (int)(aec.a(this.h) * 1.0E-6));
        int n2 = 0;
        for (zd zd2 : this.F()) {
            if (zd2 == null) continue;
            ano22.a("world[" + n2 + "][dimension]", zd2.W().a());
            ano22.a("world[" + n2 + "][mode]", (Object)this.i.l());
            ano22.a("world[" + n2 + "][difficulty]", (Object)zd2.ac());
            ano22.a("world[" + n2 + "][hardcore]", this.i.m());
            ano22.a("world[" + n2 + "][height]", this.F);
            ano22.a("world[" + n2 + "][chunks_loaded]", zd2.i().h());
            ++n2;
        }
        ano22.a("worlds", n2);
    }

    public abstract boolean j();

    public boolean T() {
        return this.A;
    }

    public void d(boolean bl2) {
        this.A = bl2;
    }

    public boolean U() {
        return this.B;
    }

    public void e(boolean bl2) {
        this.B = bl2;
    }

    public boolean V() {
        return true;
    }

    public boolean W() {
        return true;
    }

    public abstract boolean k();

    public boolean X() {
        return this.C;
    }

    public void f(boolean bl2) {
        this.C = bl2;
    }

    public boolean Y() {
        return this.D;
    }

    public void g(boolean bl2) {
        this.D = bl2;
    }

    public abstract boolean l();

    public String Z() {
        return this.E;
    }

    public void e(String string) {
        this.E = string;
    }

    public int aa() {
        return this.F;
    }

    @Override
    public void c(int n2) {
        this.F = n2;
    }

    public boolean ab() {
        return this.y;
    }

    public abp ac() {
        return this.w;
    }

    @Override
    public void a(abp abp2) {
        this.w = abp2;
    }

    public abstract boolean m();

    @Override
    public void a(bpy bpy2) {
        this.i.a(bpy2);
    }

    @Nullable
    public zu ad() {
        return this.o;
    }

    public boolean ae() {
        return this.M;
    }

    public boolean af() {
        return false;
    }

    public abstract boolean a(bpy var1, boolean var2, int var3);

    public int ag() {
        return this.z;
    }

    public ano ah() {
        return this.k;
    }

    public int ai() {
        return 16;
    }

    public boolean a(zd zd2, fu fu2, bec bec2) {
        return false;
    }

    @Override
    public void h(boolean bl2) {
        this.P = bl2;
    }

    public boolean aj() {
        return this.P;
    }

    public boolean ak() {
        return true;
    }

    public int am() {
        return this.G;
    }

    public void d(int n2) {
        this.G = n2;
    }

    public MinecraftSessionService an() {
        return this.Q;
    }

    public GameProfileRepository ao() {
        return this.R;
    }

    public abl ap() {
        return this.S;
    }

    public tl aq() {
        return this.q;
    }

    public void ar() {
        this.T = 0L;
    }

    public int as() {
        return 29999984;
    }

    @Override
    public boolean at() {
        return super.at() && !this.ab();
    }

    @Override
    public Thread au() {
        return this.U;
    }

    public int av() {
        return 256;
    }

    public long aw() {
        return this.V;
    }

    public DataFixer ax() {
        return this.s;
    }

    public int a(@Nullable zd zd2) {
        if (zd2 != null) {
            return zd2.S().c(bpx.q);
        }
        return 10;
    }

    public us ay() {
        return this.aj.g();
    }

    public uu az() {
        return this.ad;
    }

    @Override
    public CompletableFuture<Void> a(Collection<String> collection) {
        CompletionStage completionStage = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)collection.stream().map(this.Z::a).filter(Objects::nonNull).map(aap::d).collect(ImmutableList.toImmutableList()), this).thenCompose(immutableList -> uw.a((List<aae>)immutableList, this.j() ? da.a.b : da.a.c, this.h(), this.ah, this))).thenAcceptAsync(uw2 -> {
            this.aj.close();
            this.aj = uw2;
            this.Z.a(collection);
            this.i.a(MinecraftServer.a(this.Z));
            uw2.i();
            this.ac().h();
            this.ac().t();
            this.ad.a(this.aj.a());
            this.ak.a(this.aj.h());
        }, (Executor)this);
        if (this.bf()) {
            this.c(((CompletableFuture)completionStage)::isDone);
        }
        return completionStage;
    }

    public static bpn a(aar<aap> aar22, bpn bpn2, boolean bl2) {
        aar22.a();
        if (bl2) {
            aar22.a(Collections.singleton("vanilla"));
            return new bpn((List<String>)ImmutableList.of((Object)"vanilla"), (List<String>)ImmutableList.of());
        }
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (String string : bpn2.a()) {
            if (aar22.b(string)) {
                linkedHashSet.add(string);
                continue;
            }
            j.warn("Missing data pack {}", (Object)string);
        }
        for (aap aap2 : aar22.c()) {
            String string = aap2.e();
            if (bpn2.b().contains(string) || linkedHashSet.contains(string)) continue;
            j.info("Found new data pack {}, loading it automatically", (Object)string);
            linkedHashSet.add(string);
        }
        if (linkedHashSet.isEmpty()) {
            j.info("No datapacks selected, forcing vanilla");
            linkedHashSet.add("vanilla");
        }
        aar22.a(linkedHashSet);
        return MinecraftServer.a(aar22);
    }

    private static bpn a(aar<?> aar2) {
        Collection<String> collection = aar2.d();
        ImmutableList \u26032 = ImmutableList.copyOf(collection);
        List \u26033 = (List)aar2.b().stream().filter(string -> !collection.contains(string)).collect(ImmutableList.toImmutableList());
        return new bpn((List<String>)\u26032, \u26033);
    }

    @Override
    public void a(cz cz2) {
        if (!this.aL()) {
            return;
        }
        abp abp2 = cz2.j().ac();
        abw \u26032 = abp2.i();
        ArrayList \u26033 = Lists.newArrayList(abp2.s());
        for (ze ze2 : \u26033) {
            if (\u26032.a(ze2.ez())) continue;
            ze2.b.b(new ne("multiplayer.disconnect.not_whitelisted"));
        }
    }

    public aar<aap> aA() {
        return this.Z;
    }

    public da aB() {
        return this.aj.f();
    }

    public cz aC() {
        zd zd2 = this.D();
        return new cz(this, zd2 == null ? dem.a : dem.b(zd2.u()), del.a, zd2, 4, "Server", new nd("Server"), this, null);
    }

    @Override
    public boolean a() {
        return true;
    }

    @Override
    public boolean b() {
        return true;
    }

    public bmv aD() {
        return this.aj.e();
    }

    public adh aE() {
        return this.aj.d();
    }

    public ux aF() {
        return this.aa;
    }

    public czy aG() {
        if (this.ab == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.ab;
    }

    public dax aH() {
        return this.aj.c();
    }

    public day aI() {
        return this.aj.b();
    }

    public bpx aJ() {
        return this.D().S();
    }

    public va aK() {
        return this.ac;
    }

    public boolean aL() {
        return this.af;
    }

    public void i(boolean bl2) {
        this.af = bl2;
    }

    public float aM() {
        return this.ag;
    }

    public int b(GameProfile gameProfile) {
        if (this.ac().h(gameProfile)) {
            abr abr2 = (abr)this.ac().k().b(gameProfile);
            if (abr2 != null) {
                return abr2.a();
            }
            if (this.a(gameProfile)) {
                return 4;
            }
            if (this.N()) {
                return this.ac().u() ? 4 : 0;
            }
            return this.g();
        }
        return 0;
    }

    public ads aN() {
        return this.ae;
    }

    public ami aO() {
        return this.n;
    }

    public abstract boolean a(GameProfile var1);

    @Override
    public void a(Path path) throws IOException {
        \u2603 = path.resolve("levels");
        for (Map.Entry<ug<bqb>, zd> entry : this.v.entrySet()) {
            uh uh2 = entry.getKey().a();
            Path \u26032 = \u2603.resolve(uh2.b()).resolve(uh2.a());
            Files.createDirectories(\u26032, new FileAttribute[0]);
            entry.getValue().a(\u26032);
        }
        this.d(path.resolve("gamerules.txt"));
        this.e(path.resolve("classpath.txt"));
        this.c(path.resolve("example_crash.txt"));
        this.b(path.resolve("stats.txt"));
        this.f(path.resolve("threads.txt"));
    }

    private void b(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format("pending_tasks: %d\n", this.bg()));
            bufferedWriter.write(String.format("average_tick_time: %f\n", Float.valueOf(this.aM())));
            bufferedWriter.write(String.format("tick_times: %s\n", Arrays.toString(this.h)));
            bufferedWriter.write(String.format("queue: %s\n", v.f()));
        }
    }

    @Override
    private void c(Path path) throws IOException {
        j j2 = new j("Server dump", new Exception("dummy"));
        this.b(j2);
        try (BufferedWriter \u26032 = Files.newBufferedWriter(path, new OpenOption[0]);){
            \u26032.write(j2.e());
        }
    }

    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList arrayList = Lists.newArrayList();
            final bpx \u26032 = this.aJ();
            bpx.a(new bpx.c(){

                @Override
                public <T extends bpx.g<T>> void a(bpx.e<T> e2, bpx.f<T> f2) {
                    arrayList.add(String.format("%s=%s\n", e2.a(), ((bpx.g)\u26032.a(e2)).toString()));
                }
            });
            for (String string : arrayList) {
                bufferedWriter.write(string);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            String string = System.getProperty("java.class.path");
            \u2603 = System.getProperty("path.separator");
            for (String string2 : Splitter.on((String)\u2603).split((CharSequence)string)) {
                bufferedWriter.write(string2);
                bufferedWriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] \u26032 = threadMXBean.dumpAllThreads(true, true);
        Arrays.sort(\u26032, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter \u26033 = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadInfo : \u26032) {
                \u26033.write(threadInfo.toString());
                ((Writer)\u26033).write(10);
            }
        }
    }

    @Override
    private void a(@Nullable aml aml2) {
        if (this.O) {
            this.O = false;
            this.m.c();
        }
        this.n = aml.a(this.m.d(), aml2);
    }

    private void b(@Nullable aml aml2) {
        if (aml2 != null) {
            aml2.b();
        }
        this.n = this.m.d();
    }

    public boolean aQ() {
        return this.m.a();
    }

    public void aR() {
        this.O = true;
    }

    public amh aS() {
        amh amh2 = this.m.e();
        this.m.b();
        return amh2;
    }

    public Path a(dac dac2) {
        return this.d.a(dac2);
    }

    public boolean aT() {
        return true;
    }

    public cva aU() {
        return this.ak;
    }

    public dal aV() {
        return this.i;
    }

    @Override
    public /* synthetic */ void c(Runnable runnable) {
        this.b((uy)runnable);
    }

    @Override
    public /* synthetic */ boolean d(Runnable runnable) {
        return this.a((uy)runnable);
    }

    @Override
    public /* synthetic */ Runnable e(Runnable runnable) {
        return this.a(runnable);
    }
}

